# [KERNEL] Sultan Kernel for Pixel 9/Pro/Fold/XL [September 9, 2025]

```
/*
* Your warranty is no longer valid, unless you lie.
*
* I am not responsible for bricked devices, strained relationships,
* thermonuclear war, or you getting fired because the alarm app failed. Please
* do some research if you have any concerns about features included in this kernel
* before flashing it! YOU are choosing to make these modifications, and if
* you point the finger at me for messing up your device, I will laugh at you.
*
*/
```

This is a no-frills custom kernel for the Pixel 9, 9 Pro, 9 Pro Fold, and 9 Pro XL. It is designed to be used with the stock ROM and custom ROMs. It's intended to be a simple replacement for the stock kernel that brings several under-the-hood enhancements. This kernel is not meant to be customized by users.

## This kernel works with dm-verity/verification enabled! You don't need to disable verity or factory reset to use this kernel.

Changelogs for each update can be found in the 2nd post of this thread.

### Features:

    Works with dm-verity/verification enabled
    Capacity Aware Superset Scheduler (CASS), a custom CPU scheduler that improves battery life and performance
    Tensor AIO, a custom DEVFREQ driver that dynamically controls RAM and L3-cache speed for better battery life and latency
    Simple LMK, a custom low memory killer that improves memory management
    Improved thermals, so the device runs cooler
    Improved single-core and multi-core CPU performance, especially when the CPU is thermal throttled
    Improved idle battery drain when the device is in deep sleep
    Improved gaming performance
    Improved stability: fixed dozens of random reboots, freezes, memory leaks, and performance bugs which exist in the stock kernel
    Compiled with GCC 14.2 and Link Time Optimization (LTO)
    Many other advanced improvements not listed here


### Source code:
**Android 16:** https://github.com/kerneltoast/android_kernel_google_zumapro/tree/16.0.0-sultan

### Credits:

    Several beta testers who helped make this kernel stable
    osm0sis (for AnyKernel3)
    If your name should be here and it isn't, then let me know


### Installation instructions:
You can flash this kernel with the open source [Kernel Flasher](https://xdaforums.com/t/dev-kernel-flasher.4439887/) app.

### Telegram group:
https://t.me/SultanKernelUpdatesP9